

const carImage = document.getElementById("carImage");
const mockbegin = document.getElementById("mockbegin");
let currentQuestion = 0;

/* ===== Custom Modal Functions ===== */
function openModal(modalId) {
  const modal = document.getElementById(modalId);
  modal.style.display = "flex";
  modal.style.overflowY = "scroll";
  document.body.style.overflow = "hidden";
}

function closeModal(modalId) {
  const modal = document.getElementById(modalId);
  modal.style.overflowY = "";
  modal.style.display = "none";
  document.body.style.overflow = "";
}

/* ===== Quiz Load ===== */
function loadQuestion(index) {
  const q = questions[index];
  document.getElementById("questionNumber").textContent = index + 1;
  document.getElementById("questionText").textContent = q.text;

  let optionsHTML = "";
  q.options.forEach((opt, i) => {
    optionsHTML += `
      <label class="d-flex align-items-center">
        <input type="radio" name="question${index}" class="form-check-input  me-2">
        <span>${opt}</span>
      </label>`;
  });
  document.getElementById("questionOptions").innerHTML = optionsHTML;

  updateProgress();
  updateButtonLabel();
}

/* ===== Reset Progress When Start ===== */
mockbegin.onclick = function () {
  carImage.style.transition = "left 0s ease";
  carImage.style.left = '0px';
  document.getElementById("carSlider").style.width = '10%';
  document.getElementById("carSlider").style.transition = "width 0s ease";
  currentQuestion = 0;
  loadQuestion(currentQuestion);
  openModal('quizModal');
};

/* ===== Update Progress Bar ===== */
function updateProgress() {
  const progressPercent = ((currentQuestion + 1) / questions.length) * 100;
  document.getElementById("carSlider").style.width = `${progressPercent}%`;

  const containerWidth = document.querySelector(".progress-container").offsetWidth;
  if (currentQuestion > 0) {
    const carLeft = (progressPercent / 100) * containerWidth - (carImage.offsetWidth / 3);
    carImage.style.left = `${carLeft}px`;
    document.getElementById("progressText").textContent = `${progressPercent.toFixed(0)}%`;
    carImage.style.transition = "left 0.5s ease";
    document.getElementById("carSlider").style.transition = "width 0.5s ease";
  } else {
    carImage.style.transition = "left 0s ease";
    carImage.style.left = '0px';
    document.getElementById("carSlider").style.transition = "width 0s ease";
  }
}

/* ===== Change Next/Submit Button ===== */
function updateButtonLabel() {
  const nextBtn = document.getElementById("nextBtn");
  if (currentQuestion === questions.length - 1) {
    nextBtn.textContent = "Submit";
    nextBtn.classList.add("btn-success");
    nextBtn.classList.remove("btn-danger");
  } else {
    nextBtn.textContent = "Next Question";
    nextBtn.classList.add("btn-danger");
    nextBtn.classList.remove("btn-success");
  }
}

/* ===== Button Events ===== */
document.getElementById("nextBtn").addEventListener("click", () => {
  if (currentQuestion < questions.length - 1) {
    currentQuestion++;
    loadQuestion(currentQuestion);
  } else {
    closeModal('quizModal');
    setTimeout(() => {
      openModal("Modal2");
    }, 300);
  }
});

document.getElementById("prevBtn").addEventListener("click", () => {
  if (currentQuestion > 0) {
    currentQuestion--;
    loadQuestion(currentQuestion);
  }
});

/* ===== Show Final Score Modal ===== */
document.getElementById('show-score-btn').addEventListener('click', function (e) {
  e.preventDefault();
  closeModal('Modal2');
  setTimeout(() => {
    openModal("Modal3");
  }, 300);
});

/* ===== Optional: Close Modals on Background Click ===== */
document.querySelectorAll(".custom-modal").forEach(modal => {
  modal.addEventListener("click", function (e) {
    if (e.target.classList.contains("custom-modal")) {
      closeModal(modal.id);
    }
  });
});

 var swiper = new Swiper(".mockslide-content", {
    slidesPerView: 3,
    spaceBetween: 25,
    loop: true,
    centerSlide: 'true',
    fade: 'true',
    grabCursor: 'true',
  
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },

    breakpoints:{
        0: {
            slidesPerView: 1, 
        },
        520: {
            slidesPerView: 2,
        },
        950: {
            slidesPerView: 5,
        },
    },
  });